*-------------------------------------------------------------------------------
/* title : Set macros for path directories of different folders
   output: Store in memory all relevant directories needed for estimation */
*-------------------------------------------------------------------------------

*-----------------------------------SET UP--------------------------------------
cap log close
clear all
set varabbrev off 											// Turn off variable abbreviations to avoid unexpected behaviour due to ambiguity in variable and scalar names
set type double

*--------------------------------DIRECTORIES------------------------------------
/*NOTE: within the project folder there are 4 subfolders, which include: code, 
  data, output & temp. Make sure to change the project path directory below!*/

global project		"D:/projects/~" 						// Change project file directory
global code 		"$project/code" 						// Folder for code
global data			"$project/data" 						// Folder for raw data
global output_dta 	"$project/output/data" 					// Folder for output - data
global output_tex 	"$project/output/tables"				// Folder for output - tables
global output_log 	"$output_tex/_logs"						// Folder for output - tables
global output_fig 	"$project/output/figures" 				// Folder for output - figures
global temp 		"$project/temp" 						// Folder for temporary files (to be deleted at the end of the project)

*--------------CREATE FOLDERS TO STORE DATA, RESULTS & TEMP FILES---------------
foreach var in output_dta output_tex output_log output_fig temp {
	cap mkdir "$`var'"
}
